/*----------------------------------------------------------------------
  File     : Data.cpp
  Contents : data set management
  Author   : Bart Goethals
  Update   : 4/4/2003
  ----------------------------------------------------------------------*/

#include <vector>
#include <set>
using namespace std;
#include "Data.h"

Transaction::Transaction(const Transaction &tr)
{
  length = tr.length;
  t = new int[tr.length];
  for(int i=0; i< length; i++) t[i] = tr.t[i];
}

Data::Data(char *filename, int t)
{
  fn = filename;
  type = t;
  current=0;

  if(type>1) in = fopen(fn,"rt");  
  else in = fopen(fn,"rb");      
}

Data::~Data()
{
  if(in) fclose(in);
}

Transaction *Data::getNext()
{
  Transaction *t=0;

  switch(type)
    {
    case 1: t= getNextBin(); break;
    case 2: t= getNextAs(); break;
    case 3: t= getNextAsFlat(); break;
    case 4: t= getNextAsQuest(); break;
    }

  if(t) current++;
  else
    {
      rewind(in);       //ʹļָָļʼ
      current=0;
    }

  return t;
}

Transaction *Data::getNextAs()          //type = 2
{
  Transaction *t;
  int tid, item, i;
  vector<int> list;
  static int cur=0,prev=-1;         //ֲ̬ϴεʱֵ
  static bool begin=true;

  if(feof(in))                      //ļ10
    {
      begin=true;
      prev=-1;
      return 0;
    }

  if(!begin)
    {
      list.push_back(cur);           //listβcur
    }
  else begin=false;

  while(true)
    {
      int dummy;
      fscanf(in, "%d %d %d",&dummy, &tid, &item);      //Ӵ򿪵ļжȡintݸ
      //fscanf(in, "%d %d", &tid, &item);
      if(feof(in))
	{
	  int size=list.size();
	  t = new Transaction(size);
	  for(i=0; i<size; i++) t->t[i] = list[i];      //listֵ*tΪ׵ַ
	  list.clear();

	  return t;
	}
      else if(prev<0)	prev=tid;                  //ļжtidprev
      else if(tid != prev)
	{
	  prev = tid;
	  cur = item;
	  int size=list.size();
	  t = new Transaction(size);
	  for(i=0; i<size; i++) t->t[i] = list[i];
	  list.clear();
			
	  return t;
	}

      list.push_back(item);
    }
}

Transaction *Data::getNextAsFlat()           //type = 3
{
  vector<int> list;
  char c;

  // read list of items
  if(feof(in))                              //correct by me
    return 0;
  do {
    int item=0, pos=0;
    c = getc(in);                           //жȡֽ,ļָָļһַΪֵظַͱc
    while((c >= '0') && (c <= '9')) {
      item *=10;
      item += int(c)-int('0');
      c = getc(in);
      pos++;
    }
    if(pos) list.push_back(item);
  }while(c != '\n' && !feof(in));
  

  // Note, also last transaction must end with newline, 
  // else, it will be ignored
  
  // sort list of items
  // sort(list.begin(),list.end());

  // put items in Transaction structure
  Transaction *t = new Transaction(list.size());
  for(int i=0; i<int(list.size()); i++)           //listֵ*tΪ׵ַ
    t->t[i] = list[i];

  return t;
}

Transaction *Data::getNextAsQuest()
{
  int tmptid, tid,l,i;
  Transaction *t;
	
  fscanf(in,"%d %d %d",&tmptid,&tid,&l);
  if(feof(in)) return 0;
	
  t = new Transaction(l);
  for(i=0; i<l; i++)	
    fscanf(in,"%d",&t->t[i]);
  return t;
}

Transaction *Data::getNextBin()
{
  int tmptid, tid,l,i;
  Transaction *t;
	
  fread(&tmptid,4, 1,in);
  if(feof(in)) return 0;
	
  fread(&tid,4, 1,in);
  fread(&l,4, 1,in);
  t = new Transaction(l);
  for(i=0; i<l; i++)	
    {
      fread(&t->t[i],4, 1,in);
    }

  return t;
}
